<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'user';
    public $timestamps = true;
    protected $fillable = array('name', 'username', 'email', 'password', 'gender');
    protected $visible = array('birth_date');

    public function posts()
    {
        return $this->hasMany('Post');
    }

    public function comments()
    {
        return $this->hasMany('Comment');
    }

    public function reactions()
    {
        return $this->hasMany('Reaction');
    }

}